<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bed extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('bed_model');
        $this->load->model('patient/patient_model');
        $this->load->model('finance/finance_model');
        if (!$this->ion_auth->in_group(array('admin', 'Doctor', 'Accountant', 'Receptionist'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['beds'] = $this->bed_model->getBed();
        $data['categories'] = $this->bed_model->getBedCategory();
        $data['service_categories'] = $this->finance_model->getPaymentServiceCategory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('bed', $data);
        $this->load->view('home/footer'); // just the header file  
    }

    public function addBedView() {
        $data = array();
        $data['categories'] = $this->bed_model->getBedCategory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_bed_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addBed() {
        $id = $this->input->post('id');
        $payment_category_id = $this->input->post('payment_category_id');
        $number = $this->input->post('number');
        $description = $this->input->post('description');
        $status = $this->input->post('status');
        $category = $this->input->post('category');
        $c_price = $this->input->post('c_price');        
        $service_category = $this->input->post('service_category');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Category Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Price Field
        $this->form_validation->set_rules('number', 'Bed Number', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Generic Name Field
        $this->form_validation->set_rules('description', 'Description', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('c_price', 'Price', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('service_category', 'Service Category', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $data = array();
                $data['categories'] = $this->bed_model->getBedCategory();
                $data['service_categories'] = $this->finance_model->getPaymentServiceCategory();
                $data['bed'] = $this->bed_model->getBedById($id);
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_bed_view', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['categories'] = $this->bed_model->getBedCategory();
                $data['service_categories'] = $this->finance_model->getPaymentServiceCategory();
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_bed_view', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $service_category_name=$this->finance_model->getPaymentServiceCategoryById($service_category)->category;
            $data = array();
            $bed_name = implode('-', array($category, $number));
            if (empty($id)) {                
            //added by shariat
            $data1 = array();
            $data1 = array('category' => $bed_name,
                'description' => $description,
                'type' => lang('bed'),
                'c_price' => $c_price,
                'service_category' => $service_category,
                'service_category_name' => $service_category_name,
            );
                $this->finance_model->insertPaymentCategory($data1);
                $this->session->set_flashdata('feedback', lang('added'));
    
            $payment_category_id=$this->db->insert_id();
            $data = array();
            $data = array(
                'category' => $category,
                'number' => $number,
                'description' => $description,
                'bed_name' => $bed_name,
                'status' => lang('status_inactive'),
                'payment_category_id' => $payment_category_id
            );
                $this->bed_model->insertBed($data);
                $this->session->set_flashdata('feedback', lang('added')); 
            } 
            
            else {
                  //added by shariat
            $data1 = array();
            $data1 = array('category' => $bed_name,
                'description' => $description,
                'c_price' => $c_price,
            );
                $this->finance_model->updatePaymentCategory($payment_category_id, $data1);
                $this->session->set_flashdata('feedback', lang('updated'));
    
            $data = array();
            $data = array(
                'category' => $category,
                'number' => $number,
                'description' => $description,
                'bed_name' => $bed_name
            );                
                $this->bed_model->updateBed($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('bed');
        }
    }

    function editBed() {
        $data = array();
        $data['categories'] = $this->bed_model->getBedCategory();
        $id = $this->input->get('id');
        $data['bed'] = $this->bed_model->getBedById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_bed_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editBedByJason() {
        $id = $this->input->get('id');
        $data['bed'] = $this->bed_model->getBedById($id);
        $payment_category_id= $this->bed_model->getBedById($id)->payment_category_id; //added by shariat
        $data['price']=$this->finance_model->getPaymentCategoryById($payment_category_id)->c_price;
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $payment_category_id= $this->bed_model->getBedById($id)->payment_category_id; //added by shariat
        $this->bed_model->deleteBed($id);
        $this->finance_model->deletePaymentCategory($payment_category_id); //added by shariat
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('bed');
    }

    public function bedCategory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['categories'] = $this->bed_model->getBedCategory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('bed_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addCategoryView() {
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_category_view');
        $this->load->view('home/footer'); // just the header file
    }

    public function addCategory() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Category Name Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $data = array();
                $data['bed'] = $this->bed_model->getBedCategoryById($id);
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_category_view', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_category_view', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $data = array();
            $data = array('category' => $category,
                'description' => $description
            );
            if (empty($id)) {
                $this->bed_model->insertBedCategory($data);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                $this->bed_model->updateBedCategory($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('bed/bedCategory');
        }
    }

    function editCategory() {
        $data = array();
        $id = $this->input->get('id');
        $data['bed'] = $this->bed_model->getBedCategoryById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_category_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editBedCategoryByJason() {
        $id = $this->input->get('id');
        $data['bedcategory'] = $this->bed_model->getBedCategoryById($id);
        echo json_encode($data);
    }

    function deleteBedCategory() {
        $id = $this->input->get('id');
        $this->bed_model->deleteBedCategory($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('bed/bedCategory');
    }

    function bedAllotment() {
        $data['beds'] = $this->bed_model->getBed();
        $data['patients'] = $this->patient_model->getPatient();
        $data['alloted_beds'] = $this->bed_model->getAllotment();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('bed_allotment', $data);
        $this->load->view('home/footer'); // just 
    }

    function bedAllotmentRunning() {
        $data['alloted_beds'] = $this->bed_model->getBedAllotmentRunning();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('bed_allotment_running', $data);
        $this->load->view('home/footer'); // just 
    }

    function addAllotmentView() {
        $data = array();
        $id = $this->input->get('bed_id');
        $data['bed_details'] = $this->bed_model->getBedById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_allotment_view_new', $data); //changed by shariat
        $this->load->view('home/footer'); // just the header file
    }

    function addAllotment() {
        $bed_id = $this->input->post('id');
        $bed_name = $this->input->post('bed_name');
        $patient = $this->input->post('patient');
        $a_time = time(); //current time by shariat
        $status = lang(status_running); //added by shariat
        $doctor = $this->input->post('doctor');
        $diagnosis = $this->input->post('diagnosis');
        $result = $this->input->post('result');
        $guardian = $this->input->post('guardian');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Category Field
        $this->form_validation->set_rules('bed_id', 'Bed', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Patient Field
        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('status', 'Status', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('doctor', 'Doctor', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('diagnosis', 'Diagnosis', 'trim|min_length[1]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('result', 'Result', 'trim|min_length[1]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('guardian', 'Guardian', 'trim|required|min_length[1]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['beds'] = $this->bed_model->getBed();
            $data['patients'] = $this->patient_model->getPatient();
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('add_allotment_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $user = $this->ion_auth->get_user_id();
            $data = array();
            $patientDetails = $this->patient_model->getPatientById($patient);
            $data = array(
                'bed_id' => $bed_id,
                'patient' => $patient,
                'a_time' => $a_time,
                'status' => $status,
                'patient_name' => $patientDetails->name,
                'patient_phone' => $patientDetails->phone,
                'doctor' => $doctor,
                'diagnosis' => $diagnosis,
                'result' => $result,
                'add_date' => time(),
                'added_by' => $user,
            );

            $data1 = array(
                'status' => $status
            );

            if (empty($id)) {
                $this->bed_model->insertAllotment($data);
                $this->bed_model->updateBedByBedId($bed_id, $data1);
                $guardian_info = array('guardian' => $guardian);
                $this->patient_model->updatePatient($patient, $guardian_info);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                $this->bed_model->updateAllotment($id, $data);
                $this->bed_model->updateBedByBedId($bed_id, $data1);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('bed/bedAllotmentRunning');
        }
    }

    function editAllotment() {
        $data = array();
        $data['beds'] = $this->bed_model->getBed();
        $data['patients'] = $this->patient_model->getPatient();
        $id = $this->input->get('id');
        $data['allotment'] = $this->bed_model->getAllotmentById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_allotment_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editAllotmentByJason() {
        $id = $this->input->get('id');
        $data['allotment'] = $this->bed_model->getAllotmentById($id);
        $data['patient'] = $this->patient_model->getPatientById($data['allotment']->patient);
        echo json_encode($data);
    }

    function deleteBedAllotment() {
        $id = $this->input->get('id');
        $bed_id = $this->input->get('bed_id');
        $data1 = array(
            'status' => lang(status_inactive)
        );
        $this->bed_model->deleteBedAllotment($id); //changed by shariat
        $this->bed_model->updateBedByBedId($bed_id, $data1); //added by shariat
        $this->session->set_flashdata('feedback', lang('cancelled_allotment'));
        redirect('bed/bedAllotmentRunning');
    }

    function getBedList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $settings = $this->settings_model->getSettings();

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "bed_name",
            "1" => "description",
            "3" => "status",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['beds'] = $this->bed_model->getBedBysearch($search, $order, $dir);
            } else {
                $data['beds'] = $this->bed_model->getBedWithoutSearch($order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['beds'] = $this->bed_model->getBedByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['beds'] = $this->bed_model->getBedByLimit($limit, $start, $order, $dir);
            }
        }

        $i = 0;
        foreach ($data['beds'] as $bed) {
            $i = $i + 1;

            $option1 = '<button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="' . $bed->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</button>';

            $option2 = '<a class="btn btn-danger btn-xs btn_width" href="bed/delete?id=' . $bed->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
                
            if ($bed->status == 'running') 
            {           
                $option3="";
                $bedstatus = '<button type="button" class="btn btn-danger">' . lang('alloted') . '</button>';
            } else {
                $bedstatus = '<button type="button" class="btn btn-success ">' . lang('available') . '</button>';
                $option3 = '<a class="btn btn-warning btn-xs btn_width" href="bed/addAllotmentView?bed_id=' . $bed->id . '" ><i class="fa fa-plus-circle"> </i> ' . lang('add_allotment') . '</a>';    
            }

            $price=$this->finance_model->getPaymentCategoryById($bed->payment_category_id)->c_price;

            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $bed->bed_name, //changed by shariat
                    $bed->description,
                     $settings->currency . ' ' .$price,
                    $bedstatus,
                    $option1 . ' ' . $option2
                );
            }
            else
            {
                $info[] = array(
                   $bed->bed_name,
                   $bed->description,
                   $settings->currency . ' ' .$price,
                   $bedstatus,
                   $option3 . ' ' .$option1
            );
        }
    }

        if (!empty($data['beds'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('bed')->num_rows(),
                "recordsFiltered" => $this->db->get('bed')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getBedAllotmentList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "bed_name",
            "2" => "patient_name",
            "4" => "a_time",
            "5" => "d_time",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['beds'] = $this->bed_model->getBedAllotmentBysearch($search, $order, $dir);
            } else {
                $data['beds'] = $this->bed_model->getAllotmentWithoutSearch($order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['beds'] = $this->bed_model->getBedAllotmentByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['beds'] = $this->bed_model->getBedAllotmentByLimit($limit, $start, $order, $dir);
            }
        }

        foreach ($data['beds'] as $bed) {
            $patientdetails = $bed->patient_name. ', '. $bed->patient_phone. ', ID: '.  $bed->patient;
            $guardian = $this->patient_model->getPatientById($bed->patient)->guardian;
            $beddetails = $bed->bed_name; //added by shariat
            if (empty($bed->d_time))
            {           
            $d_time = "";
            $option2 = '<a class="btn btn-warning btn-xs btn_width" href="bed/cancelAllotmentView?id=' . $bed->id . '" ><i class="fa fa-window-close"> </i> ' . lang('cancel') . '</a>';
            $duration="";    
            $option5="";
            }
            else
            {
            $d_time = date('d-m-Y h:i A',$bed->d_time);
            $option2="";
            $duration=ceil(($bed->d_time-$bed->a_time)/86400).' '.lang('days'); // 86400 s = 1 day
            $option5='<a target="_blank" class="btn btn-info btn-xs" title="' . lang('print') . '" style="color: #fff;" href="bed/printDischarge?id=' . $bed->id . '"><i class="fa fa-file"></i> ' . lang('print').' '. lang('discharge') . '</a>';
            }

            if ($this->ion_auth->in_group('admin')) {
                $option3 = '<a class="btn btn-danger btn-xs btn_width" href="bed/deleteBedAllotment?id=' . $bed->id . '&bed_id=' .$bed->bed_id . '" onclick="return confirm(\'Are you sure you want to delete this allotment?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>';
            }

            $option4='<a target="_blank" class="btn btn-info btn-xs invoicebutton" title="' . lang('print') . '" style="color: #fff;" href="bed/printAllotment?id=' . $bed->id . '"><i class="fa fa-file-invoice"></i> ' . lang('print').' '. lang('admission') . '</a>';
            
            $info[] = array(
                $bed->id,
                $beddetails,
                $patientdetails,
                $guardian,
                date('d-m-Y h:i A',$bed->a_time),
                $d_time,
                $duration,
                $bed->diagnosis,
                $bed->result,
                $bed->problem,
                $bed->reason,
                $bed->remarks,
                $bed->doctorName.', '.$bed->doctordepartment.', '.lang('id').': '. $bed->doctorId,
                $option4.' '.$option2.' '.$option3.' '.$option5,
            );
        }

        if (!empty($data['beds'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('alloted_bed'),
                "recordsFiltered" => $this->db->count_all_results('alloted_bed'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function printAllotment() {
        $id = $this->input->get('id');
        $data['bed'] = $this->bed_model->getAllotmentById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('print_allotment', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    function cancelAllotmentView() {
        $data = array();
        $id = $this->input->get('id');
        $data['allotment_details'] = $this->bed_model->getAllotmentById($id);
        $data['bed']=$this->bed_model->getBedById($data['allotment_details']->bed_id)->bed_name;
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('cancel_allotment_view', $data); //changed by shariat
        $this->load->view('home/footer'); // just the header file
    }

    function cancelBedAllotment() {
        $id = $this->input->post('id'); 
        $bed_id = $this->input->post('bed_id');       
        $reason = $this->input->post('reason');
        $problem = $this->input->post('problem');
        $remarks = $this->input->post('remarks');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('reason', 'Reason', 'trim|required|min_length[1]|max_length[50]|xss_clean');
        $this->form_validation->set_rules('problem', 'Problem', 'trim|min_length[1]|max_length[500]|xss_clean');
        $this->form_validation->set_rules('remarks', 'Remarks', 'trim|min_length[1]|max_length[200]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $id = $this->input->get('id');
            $data['allotment_details'] = $this->bed_model->getAllotmentById($id);
            $data['bed']=$this->bed_model->getBedById($data['allotment_details']->bed_id)->bed_name;
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('cancel_allotment_view', $data); //changed by shariat
            $this->load->view('home/footer'); // just the header file
        } else {
            $status=lang(status_inactive);
            $d_time = time();   
            $user = $this->ion_auth->get_user_id();
            $data = array();
            $data = array(
                'd_time' => $d_time,
                'reason' => $reason,
                'problem' => $problem,
                'remarks' => $remarks,
                'status' => $status,
                'update_date' => $d_time,
                'updated_by' => $user,
            );

            $data1 = array('status' => $status);

            $this->bed_model->updateAllotment($id,$data); //changed by shariat
            $this->bed_model->updateBedByBedId($bed_id, $data1); //added by shariat
            redirect('bed/bedAllotment');
        }
    }

    function printDischarge() {
        $id = $this->input->get('id');
        $data['bed'] = $this->bed_model->getAllotmentById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('print_discharge', $data);
        $this->load->view('home/footer'); // just the footer fi
    }
}

/* End of file bed.php */
/* Location: ./application/modules/bed/controllers/bed.php */
