
<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
            <?php echo lang('staff'); ?> <?php echo lang('leave'); ?> <?php echo lang('list'); ?>
                <div class="clearfix no-print col-md-8 pull-right">
                <?php echo validation_errors(); ?>
                    <div class="pull-right"></div>
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs">
                                <i class="fa fa-plus-circle"></i>  <?php echo lang('add_new'); ?> <?php echo lang('leave'); ?> 
                            </button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">

                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th><?php echo lang('serial'); ?></th>
                                <th><?php echo lang('staff'); ?></th>
                                <th><?php echo lang('department'); ?></th>
                                <th><?php echo lang('leave'); ?> <?php echo lang('type'); ?></th>
                                <th><?php echo lang('reason'); ?></th>
                                <th><?php echo lang('leave'); ?> <?php echo lang('from'); ?></th>
                                <th><?php echo lang('leave'); ?> <?php echo lang('to'); ?></th>
                                <th><?php echo lang('total'); ?></th>
                                <th><?php echo lang('remarks'); ?></th>
                                <th><?php echo lang('status'); ?></th>
                                <th><?php echo lang('added'); ?> <?php echo lang('date'); ?></th>
                                <th class="no-print"><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($leaves as $leave) { ?>
                            <tr class="">
                                <td><?php echo $leave->id; ?></td>
                                <td><?php echo $leave->staffName; ?>, <?php echo lang('id'); ?>: <?php echo $leave->staff; ?></td>
                                <td><?php echo $leave->departmentName; ?></td>
                                <td><?php echo $leave->leave_type; ?></td>
                                <td><?php echo $leave->reason; ?></td>
                                <td><?php echo date('d-m-Y', $leave->leave_from); ?></td>
                                <td><?php echo date('d-m-Y', $leave->leave_to); ?></td>
                                <td><span class="badge bg-success"><?php echo $leave->total_leave; ?> <?php echo lang('days'); ?></span></td>                               
                                <td><?php echo $leave->remarks; ?></td>                               
                                <td>
                                <?php if ($leave->status == lang('approved')) { ?>
                                    <span class="badge bg-primary"><?php echo $leave->status; ?></span>
                                <?php } elseif ($leave->status == lang('pending')) { ?> 
                                    <span class="badge bg-info"><?php echo $leave->status; ?></span>
                                <?php } else { ?> 
                                    <span class="badge bg-warning"><?php echo $leave->status; ?></span>
                                <?php } ?> 
                                </td>
                                <td><?php echo date('d-m-Y', $leave->applied_on); ?></td>
                                <td class="no-print">
                                    <?php echo ' <a type="button" class="btn detailsbutton inffo" title="' . lang('info') . '" data-toggle = "modal" data-id="' . $leave->id . '"><i class="fa fa-info"> </i> ' . lang('details') . '</a>'; ?>
                                    <button type="button" class="btn btn-info btn-xs btn_width editbutton" title="<?php echo lang('edit'); ?>" data-toggle="modal" data-id="<?php echo $leave->id; ?>"><i class="fa fa-edit"></i> <?php echo lang('edit'); ?></button>   
                                    <a class="btn btn-info btn-xs btn_width delete_button" title="<?php echo lang('delete'); ?>" href="leave/deleteLeave?id=<?php echo $leave->id; ?>" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i> <?php echo lang('delete'); ?></a>
                                </td>
                            </tr>
                        <?php } ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<!-- Add Leave Modal-->
<div class="modal fade" id="myModal"  role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><?php echo lang('add_new'); ?> <?php echo lang('leave'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" action="staff/addLeave" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?>*</label>
                        <select class="form-control js-example-basic-single" name="staff" required>
                            <option value="">Select</option>
                                <?php foreach ($staffs as $staff) { ?>
                                    <option value="<?php echo $staff->id; ?>">
                                    <?php echo $staff->name.", ".lang('id').": ".$staff->id.", ".$staff->departmentName; ?> 
                                    </option>
                                <?php } ?> 
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('leave'); ?> <?php echo lang('type'); ?>*</label>
                        <select class="form-control" name="leave_type" required> 
							<option value="">Select</option>  
                            <option><?php echo lang('leave_type_sick'); ?></option> 
                            <option><?php echo lang('leave_type_earned'); ?></option> 
                            <option><?php echo lang('leave_type_casual'); ?></option> 
                            <option><?php echo lang('leave_type_maternity'); ?></option> 
                            <option><?php echo lang('leave_type_without_pay'); ?></option> 
                            <option><?php echo lang('others'); ?></option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('reason'); ?></label>
                        <input type="text" class="form-control" name="reason">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('from'); ?>*</label>
                        <input type="text" class="form-control default-date-picker" name="leave_from" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('to'); ?>*</label>
                        <input type="text" class="form-control default-date-picker" name="leave_to" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('remarks'); ?></label>
                        <input type="text" class="form-control" name="remarks">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('status'); ?>*</label>
                        <select class="form-control" name="status" required>  
                            <option><?php echo lang('approved'); ?></option> 
                            <option><?php echo lang('pending'); ?></option>
                            <option><?php echo lang('rejected'); ?></option>  
                        </select>
                    </div>                     

                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash();?>" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right row"><?php echo lang('submit'); ?></button>
                    </div>

                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Add Leave Modal-->

<!-- Info Leave Modal-->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg"> 
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">  <?php echo lang('leave'); ?>  <?php echo lang('info'); ?> (<?php echo lang('id'); ?>: <span class="leaveIdClass text-primary"></span>)</h4>
            </div>
            <div class="modal-body row" style="margin-top: 15px;">                    
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?></label>
                        <div class="staffClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('leave'); ?> <?php echo lang('type'); ?></label>
                        <div class="leaveTypeClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('from'); ?></label>
                        <div class="leaveFromClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('to'); ?></label>
                        <div class="leaveToClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('reason'); ?></label>
                        <div class="reasonClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('remarks'); ?></label>
                        <div class="remarksClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('status'); ?></label>
                        <div class="statusClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('added'); ?> <?php echo lang('date'); ?></label>
                        <div class="addedDateClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('added'); ?> <?php echo lang('by'); ?></label>
                        <div class="addedByClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('updated'); ?> <?php echo lang('date'); ?></label>
                        <div class="updatedDateClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('updated'); ?> <?php echo lang('by'); ?></label>
                        <div class="updatedByClass"></div>     
                    </div>

                    <div class="form-group col-md-6">    
                    </div>
              

            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div>
</div>
<!-- Info Leave Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><?php echo lang('edit'); ?> <?php echo lang('leave'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editLeaveForm" class="clearfix" action="staff/addLeave" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('serial'); ?></label>
                        <input type="text" class="form-control" name="id" value='' placeholder="" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?>*</label>
                        <input type="text" class="form-control" name="staff" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('leave'); ?> <?php echo lang('type'); ?>*</label>
                        <select class="form-control" name="leave_type" required> 
							<option value="">Select</option>  
                            <option><?php echo lang('leave_type_sick'); ?></option> 
                            <option><?php echo lang('leave_type_earned'); ?></option> 
                            <option><?php echo lang('leave_type_casual'); ?></option> 
                            <option><?php echo lang('leave_type_maternity'); ?></option> 
                            <option><?php echo lang('leave_type_without_pay'); ?></option> 
                            <option><?php echo lang('others'); ?></option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('reason'); ?></label>
                        <input type="text" class="form-control" name="reason">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('from'); ?>*</label>
                        <input type="text" class="form-control default-date-picker" name="leave_from" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('to'); ?>*</label>
                        <input type="text" class="form-control default-date-picker" name="leave_to" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('remarks'); ?></label>
                        <input type="text" class="form-control" name="remarks">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('status'); ?>*</label>
                        <select class="form-control" name="status" required>  
                            <option><?php echo lang('approved'); ?></option> 
                            <option><?php echo lang('pending'); ?></option>
                            <option><?php echo lang('rejected'); ?></option>  
                        </select>
                    </div>                      
                    
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash();?>" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right row"><?php echo lang('submit'); ?></button>
                    </div>

                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,

            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9],
                    }
                },
            ],

            aLengthMenu: [
                [25, 50, 100],
                [25, 50, 100]
            ],
            iDisplayLength: 25,
            "order": [[0, "desc"]],

            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json" 
            },
        });
        table.buttons().container()
                .appendTo('.custom_buttons');
    });
</script>

<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>

<script type="text/javascript">

    $(".table").on("click", ".inffo", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute  
        var iid = $(this).attr('data-id');
        $('.leaveIdClass').html("").end() 
        $('.staffClass').html("").end()  
        $('.leaveTypeClass').html("").end()  
        $('.reasonClass').html("").end()  
        $('.leaveFromClass').html("").end()  
        $('.leaveToClass').html("").end()  
        $('.remarksClass').html("").end()  
        $('.statusClass').html("").end()       
        $('.addedByClass').html("").end()
        $('.addedDateClass').html("").end()
        $('.updatedByClass').html("").end()
        $('.updatedDateClass').html("").end()

        $.ajax({
            url: 'staff/getLeaveByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $('.leaveIdClass').append(response.leave.id).end()
            $('.staffClass').append(response.leave.staffName+", <?php echo lang('id');?>: "+response.leave.staff+", "+response.leave.departmentName).end()
            $('.leaveTypeClass').append(response.leave.leave_type).end()
            $('.reasonClass').append(response.leave.reason).end()
            $('.leaveFromClass').append(response.leave_from).end()
            $('.leaveToClass').append(response.leave_to).end()
            $('.remarksClass').append(response.leave.remarks).end()
            $('.statusClass').append(response.leave.status).end()
            $('.addedByClass').append(response.added_by).end()
            $('.addedDateClass').append(response.added_date).end()
            $('.updatedByClass').append(response.updated_by).end()
            $('.updatedDateClass').append(response.updated_date).end()

            $('#infoModal').modal('show');

        });
    });

</script>


<script type="text/javascript">

    $(".table").on("click", ".editbutton", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute  
        var iid = $(this).attr('data-id');
        $('#editLeaveForm').trigger("reset");
        $.ajax({
            url: 'staff/getLeaveByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $('#editLeaveForm').find('[name="id"]').val(response.leave.id).end()
            $('#editLeaveForm').find('[name="staff"]').val(response.leave.staffName+", <?php echo lang('id');?>: "+response.leave.staff+", "+response.leave.departmentName).end()
            $('#editLeaveForm').find('[name="leave_type"]').val(response.leave.leave_type).end()
            $('#editLeaveForm').find('[name="leave_from"]').val(response.leave_from).end()
            $('#editLeaveForm').find('[name="leave_to"]').val(response.leave_to).end()
            $('#editLeaveForm').find('[name="reason"]').val(response.leave.reason).end()
            $('#editLeaveForm').find('[name="remarks"]').val(response.leave.remarks).end() 
            $('#editLeaveForm').find('[name="status"]').val(response.leave.status).end() 

            $('#myModal2').modal('show');

        });
    });

</script>