<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pharmacy_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertPayment($data) {
        $this->db->insert('pharmacy_payment', $data);
    }

    function insertDeposit($data) {
        $this->db->insert('pharmacy_deposit', $data);
    }

    function getPayment() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPaymentWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,date,patient,patient_name,patient_phone,doctor,gross_total,user');
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pharmacy_payment');
        return $query->row();
    }

    function getPaymentByKey($page_number, $key) {
        $data_range_1 = 50 * $page_number;
        $this->db->like('id', $key);
        $this->db->order_by('id', 'asc');
        $query = $this->db->get('pharmacy_payment', 50, $data_range_1);
        return $query->result();
    }

    function getPaymentByPatientId($id) {
        $this->db->order_by('id', 'desc');
        $this->db->where('patient', $id);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPaymentByPageNumber($page_number) {
        $data_range_1 = 50 * $page_number;
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('pharmacy_payment', 50, $data_range_1);
        return $query->result();
    }

    function updatePayment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('pharmacy_payment', $data);
    }

    function deletePayment($id) {
        $this->db->where('id', $id);
        $this->db->delete('pharmacy_payment');
    }

    function insertExpense($data) {
        $this->db->insert('pharmacy_expense', $data);
    }

    function getExpense() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('pharmacy_expense');
        return $query->result();
    }

    function getExpenseById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pharmacy_expense');
        return $query->row();
    }

    function updateExpense($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('pharmacy_expense', $data);
    }

    function insertExpenseCategory($data) {
        $this->db->insert('pharmacy_expense_category', $data);
    }

    function getExpenseCategory() {
        $query = $this->db->get('pharmacy_expense_category');
        return $query->result();
    }

    function getExpenseCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pharmacy_expense_category');
        return $query->row();
    }

    function updateExpenseCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('pharmacy_expense_category', $data);
    }

    function deleteExpense($id) {
        $this->db->where('id', $id);
        $this->db->delete('pharmacy_expense');
    }

    function deleteExpenseCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('pharmacy_expense_category');
    }

    function getDiscountType() {
        $query = $this->db->get('settings');
        return $query->row()->discount;
    }

    function getPaymentByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('pharmacy_payment');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getPaymentByDateShortForm($date_from, $date_to) {
        $this->db->select('id,date,gross_total,user,deposit_type,flat_discount,amount');
        $this->db->from('pharmacy_payment');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getExpenseByDate($date_from, $date_to) {
        $this->db->select('category, sum(amount) AS tot_amount,count(category) AS freq_expense');
        $this->db->from('pharmacy_expense');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $this->db->group_by('category_id'); 
        $query = $this->db->get();
        return $query->result();
    }

    function getExpenseByDateList($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('pharmacy_expense');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to); 
        $query = $this->db->get();
        return $query->result();
    }

    function amountReceived($id, $data) {
        $this->db->where('id', $id);
        $query = $this->db->update('pharmacy_payment', $data);
    }

    function todaySalesAmount() {
        $hour = 0;
        $today = strtotime($hour . ':00:00'); // 0:00:00 means today
        $today_last = strtotime($hour . ':00:00') + 86399; //11:59:59 means today last time
        $this->db->select('count(id) as pay_number, sum(gross_total) as total');
        $this->db->where('date >=', $today);
        $this->db->where('date <=', $today_last);
        $this->db->from('pharmacy_payment');
        $query = $this->db->get()->result();
        return $query;
    }

    function todayExpensesAmount() {
        $hour = 0;
        $today = strtotime($hour . ':00:00'); // 0:00:00 means today
        $today_last = strtotime($hour . ':00:00') + 86399; //11:59:59 means today last time
        $this->db->select('count(id) as expense_number, sum(amount) as total');
        $this->db->where('date >=', $today);
        $this->db->where('date <=', $today_last);
        $this->db->from('pharmacy_expense');
        $query = $this->db->get()->result();
        return $query;
    }

    function getPaymentBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,date,patient,patient_name,patient_phone,doctor,gross_total,user');
        $this->db->like('id', $search);
        $this->db->or_like('patient_name', $search);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPaymentByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,date,patient,patient_name,patient_phone,doctor,gross_total,user');
        $this->db->limit($limit, $start);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPaymentByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,date,patient,patient_name,patient_phone,doctor,gross_total,user');
        $this->db->like('id', $search);
        $this->db->or_like('patient_name', $search);
        $this->db->limit($limit, $start);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
        }
    }

    function getExpenseByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('pharmacy_expense');
        return $query->result();
    }

    function getExpenseByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search);
        $this->db->or_like('amount', $search);
        $this->db->or_like('category', $search);
        $this->db->or_like('remarks', $search);
        $this->db->limit($limit, $start);
        $query = $this->db->get('pharmacy_expense');
        return $query->result();
    }

    function getFirstRowPaymentById() {

        $last = $this->db->order_by('id', "asc")
                ->limit(1)
                ->get('pharmacy_payment')
                ->row();
        return $last;
    }

    function getLastRowPaymentById() {

        $last = $this->db->order_by('id', "desc")
                ->limit(1)
                ->get('pharmacy_payment')
                ->row();
        return $last;
    }

    function getPreviousPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pharmacy_payment');
        return $query->previous_row();
    }

    function getNextPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pharmacy_payment');
        return $query->row();
    }

    function thisMonthPayment() {
        $date_from = strtotime('first day of '. date ('F Y')); 
        $date_to = strtotime('last day of '. date ('F Y')) + 86399; //11:59:59 PM
        $this->db->select_sum('gross_total');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $this->db->from('pharmacy_payment');
        $query = $this->db->get()->result();
        return $query[0]->gross_total;
    }

    function thisMonthExpense() {
        $date_from = strtotime('first day of '. date ('F Y')); 
        $date_to = strtotime('last day of '. date ('F Y')) + 86399; //11:59:59 PM
        $this->db->select_sum('amount');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $this->db->from('pharmacy_expense');
        $query = $this->db->get()->result();
        return $query[0]->amount;
    }

    function thisDayPayment() {
        $query = $this->db->get('pharmacy_payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->date)) {
                $total[] = $q->gross_total;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisDayExpense() {
        $query = $this->db->get('pharmacy_expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearPayment() {
        $query = $this->db->get('pharmacy_payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                $total[] = $q->gross_total;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearExpense() {
        $query = $this->db->get('pharmacy_expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function getPaymentPerMonthThisYear() {
        $query = $this->db->select ('date,gross_total')->get('pharmacy_payment')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                if (date('m', $q->date) == '01') {
                    $total['january'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '02') {
                    $total['february'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '03') {
                    $total['march'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '04') {
                    $total['april'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '05') {
                    $total['may'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '06') {
                    $total['june'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '07') {
                    $total['july'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '08') {
                    $total['august'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '09') {
                    $total['september'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '10') {
                    $total['october'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '11') {
                    $total['november'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '12') {
                    $total['december'][] = $q->gross_total;
                }
            }
        }


        if (!empty($total['january'])) {
            $total['january'] = array_sum($total['january']);
        } else {
            $total['january'] = 0;
        }
        if (!empty($total['february'])) {
            $total['february'] = array_sum($total['february']);
        } else {
            $total['february'] = 0;
        }
        if (!empty($total['march'])) {
            $total['march'] = array_sum($total['march']);
        } else {
            $total['march'] = 0;
        }
        if (!empty($total['april'])) {
            $total['april'] = array_sum($total['april']);
        } else {
            $total['april'] = 0;
        }
        if (!empty($total['may'])) {
            $total['may'] = array_sum($total['may']);
        } else {
            $total['may'] = 0;
        }
        if (!empty($total['june'])) {
            $total['june'] = array_sum($total['june']);
        } else {
            $total['june'] = 0;
        }
        if (!empty($total['july'])) {
            $total['july'] = array_sum($total['july']);
        } else {
            $total['july'] = 0;
        }
        if (!empty($total['august'])) {
            $total['august'] = array_sum($total['august']);
        } else {
            $total['august'] = 0;
        }
        if (!empty($total['september'])) {
            $total['september'] = array_sum($total['september']);
        } else {
            $total['september'] = 0;
        }
        if (!empty($total['october'])) {
            $total['october'] = array_sum($total['october']);
        } else {
            $total['october'] = 0;
        }
        if (!empty($total['november'])) {
            $total['november'] = array_sum($total['november']);
        } else {
            $total['november'] = 0;
        }
        if (!empty($total['december'])) {
            $total['december'] = array_sum($total['december']);
        } else {
            $total['december'] = 0;
        }

        return $total;
    }

    function getExpensePerMonthThisYear() {
        $query = $this->db->select('date,amount')->get('pharmacy_expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                if (date('m', $q->date) == '01') {
                    $total['january'][] = $q->amount;
                }
                if (date('m', $q->date) == '02') {
                    $total['february'][] = $q->amount;
                }
                if (date('m', $q->date) == '03') {
                    $total['march'][] = $q->amount;
                }
                if (date('m', $q->date) == '04') {
                    $total['april'][] = $q->amount;
                }
                if (date('m', $q->date) == '05') {
                    $total['may'][] = $q->amount;
                }
                if (date('m', $q->date) == '06') {
                    $total['june'][] = $q->amount;
                }
                if (date('m', $q->date) == '07') {
                    $total['july'][] = $q->amount;
                }
                if (date('m', $q->date) == '08') {
                    $total['august'][] = $q->amount;
                }
                if (date('m', $q->date) == '09') {
                    $total['september'][] = $q->amount;
                }
                if (date('m', $q->date) == '10') {
                    $total['october'][] = $q->amount;
                }
                if (date('m', $q->date) == '11') {
                    $total['november'][] = $q->amount;
                }
                if (date('m', $q->date) == '12') {
                    $total['december'][] = $q->amount;
                }
            }
        }


        if (!empty($total['january'])) {
            $total['january'] = array_sum($total['january']);
        } else {
            $total['january'] = 0;
        }
        if (!empty($total['february'])) {
            $total['february'] = array_sum($total['february']);
        } else {
            $total['february'] = 0;
        }
        if (!empty($total['march'])) {
            $total['march'] = array_sum($total['march']);
        } else {
            $total['march'] = 0;
        }
        if (!empty($total['april'])) {
            $total['april'] = array_sum($total['april']);
        } else {
            $total['april'] = 0;
        }
        if (!empty($total['may'])) {
            $total['may'] = array_sum($total['may']);
        } else {
            $total['may'] = 0;
        }
        if (!empty($total['june'])) {
            $total['june'] = array_sum($total['june']);
        } else {
            $total['june'] = 0;
        }
        if (!empty($total['july'])) {
            $total['july'] = array_sum($total['july']);
        } else {
            $total['july'] = 0;
        }
        if (!empty($total['august'])) {
            $total['august'] = array_sum($total['august']);
        } else {
            $total['august'] = 0;
        }
        if (!empty($total['september'])) {
            $total['september'] = array_sum($total['september']);
        } else {
            $total['september'] = 0;
        }
        if (!empty($total['october'])) {
            $total['october'] = array_sum($total['october']);
        } else {
            $total['october'] = 0;
        }
        if (!empty($total['november'])) {
            $total['november'] = array_sum($total['november']);
        } else {
            $total['november'] = 0;
        }
        if (!empty($total['december'])) {
            $total['december'] = array_sum($total['december']);
        } else {
            $total['december'] = 0;
        }

        return $total;
    }

    function getDepositAmountByPaymentId($payment_id) {
        $this->db->select('deposited_amount');
        $this->db->from('pharmacy_deposit');
        $this->db->where('payment_id', $payment_id);
        $query = $this->db->get();
        $total = array();
        $deposited_total = array();
        $total = $query->result();

        foreach ($total as $deposit) {
            $deposited_total[] = $deposit->deposited_amount;
        }

        if (!empty($deposited_total)) {
            $deposited_total = array_sum($deposited_total);
        } else {
            $deposited_total = 0;
        }

        return $deposited_total;
    }

    function deleteDepositByInvoiceId($id) {
        $this->db->where('payment_id', $id);
        $this->db->delete('pharmacy_deposit');
    }

    function getPaymentPerMonthYear($year) {
        $query = $this->db->get('pharmacy_payment')->result();
        $total = array();
        foreach ($query as $q) {
            if ($year == date('Y', $q->date)) {
                if (date('m', $q->date) == '01') {
                    $total['january'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '02') {
                    $total['february'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '03') {
                    $total['march'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '04') {
                    $total['april'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '05') {
                    $total['may'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '06') {
                    $total['june'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '07') {
                    $total['july'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '08') {
                    $total['august'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '09') {
                    $total['september'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '10') {
                    $total['october'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '11') {
                    $total['november'][] = $q->gross_total;
                }
                if (date('m', $q->date) == '12') {
                    $total['december'][] = $q->gross_total;
                }
            }
        }


        if (!empty($total['january'])) {
            $total['january'] = array_sum($total['january']);
        } else {
            $total['january'] = 0;
        }
        if (!empty($total['february'])) {
            $total['february'] = array_sum($total['february']);
        } else {
            $total['february'] = 0;
        }
        if (!empty($total['march'])) {
            $total['march'] = array_sum($total['march']);
        } else {
            $total['march'] = 0;
        }
        if (!empty($total['april'])) {
            $total['april'] = array_sum($total['april']);
        } else {
            $total['april'] = 0;
        }
        if (!empty($total['may'])) {
            $total['may'] = array_sum($total['may']);
        } else {
            $total['may'] = 0;
        }
        if (!empty($total['june'])) {
            $total['june'] = array_sum($total['june']);
        } else {
            $total['june'] = 0;
        }
        if (!empty($total['july'])) {
            $total['july'] = array_sum($total['july']);
        } else {
            $total['july'] = 0;
        }
        if (!empty($total['august'])) {
            $total['august'] = array_sum($total['august']);
        } else {
            $total['august'] = 0;
        }
        if (!empty($total['september'])) {
            $total['september'] = array_sum($total['september']);
        } else {
            $total['september'] = 0;
        }
        if (!empty($total['october'])) {
            $total['october'] = array_sum($total['october']);
        } else {
            $total['october'] = 0;
        }
        if (!empty($total['november'])) {
            $total['november'] = array_sum($total['november']);
        } else {
            $total['november'] = 0;
        }
        if (!empty($total['december'])) {
            $total['december'] = array_sum($total['december']);
        } else {
            $total['december'] = 0;
        }

        return $total;
    }


    function getPaymentByPatientIdByDate($id, $date_from, $date_to) {
        $this->db->order_by('id', 'desc');
        $this->db->select('id,date,gross_total,user,deposit_type');
        $this->db->where('patient', $id);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getDepositByPatientId($id) {
        $this->db->order_by('id', 'desc');
        $this->db->select('id,date,deposit_type,payment_id,deposited_amount');
        $this->db->where('patient', $id);
        $query = $this->db->get('pharmacy_deposit');
        return $query->result();
    }

    function getDepositByPatientIdByDate($id, $date_from, $date_to) {
        $this->db->order_by('id', 'desc');
        $this->db->select('id,date,deposit_type,payment_id,deposited_amount');
        $this->db->where('patient', $id);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get('pharmacy_deposit');
        return $query->result();
    }

    function getDepositById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pharmacy_deposit');
        return $query->row();
    }

    function deleteDeposit($id) {
        $this->db->where('id', $id);
        $this->db->delete('pharmacy_deposit');
    }

    function getPaymentByUserId($id) {
        $this->db->order_by('id', 'desc');
        $this->db->select('id,date,gross_total,user,deposit_type');
        $this->db->where('user', $id);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getDepositsByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('pharmacy_deposit');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getPaymentByUserIdByDate($user, $date_from, $date_to) {
        $this->db->order_by('id', 'desc');
        $this->db->select('id,date,gross_total,user,deposit_type');
        $this->db->from('pharmacy_payment');
        $this->db->where('user', $user);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getDepositByUserIdByDate($user, $date_from, $date_to) {
        $this->db->order_by('id', 'desc');
        $this->db->select('id,date,deposit_type,payment_id,deposited_amount');
        $this->db->from('pharmacy_deposit');
        $this->db->where('user', $user);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getPaymentCategory() {
		$this->db->order_by('name', 'asc'); //added by shariat
        $query = $this->db->get('medicine');
        return $query->result();
    }
}
