<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

abstract class ChannelOptions {
    /**
     * @param string $target Target Contact Identity
     * @param string $chatUniqueName Chat channel unique name
     * @param string $preEngagementData Pre-engagement data
     * @param string $taskSid TaskRouter Task Sid.
     * @param string $taskAttributes Task attributes to be added for the TaskRouter
     *                               Task
     * @param bool $longLived Long Lived flag
     * @return CreateChannelOptions Options builder
     */
    public static function create($target = Values::NONE, $chatUniqueName = Values::NONE, $preEngagementData = Values::NONE, $taskSid = Values::NONE, $taskAttributes = Values::NONE, $longLived = Values::NONE) {
        return new CreateChannelOptions($target, $chatUniqueName, $preEngagementData, $taskSid, $taskAttributes, $longLived);
    }
}

class CreateChannelOptions extends Options {
    /**
     * @param string $target Target Contact Identity
     * @param string $chatUniqueName Chat channel unique name
     * @param string $preEngagementData Pre-engagement data
     * @param string $taskSid TaskRouter Task Sid.
     * @param string $taskAttributes Task attributes to be added for the TaskRouter
     *                               Task
     * @param bool $longLived Long Lived flag
     */
    public function __construct($target = Values::NONE, $chatUniqueName = Values::NONE, $preEngagementData = Values::NONE, $taskSid = Values::NONE, $taskAttributes = Values::NONE, $longLived = Values::NONE) {
        $this->options['target'] = $target;
        $this->options['chatUniqueName'] = $chatUniqueName;
        $this->options['preEngagementData'] = $preEngagementData;
        $this->options['taskSid'] = $taskSid;
        $this->options['taskAttributes'] = $taskAttributes;
        $this->options['longLived'] = $longLived;
    }

    /**
     * Target Contact Identity, for example phone number for SMS
     *
     * @param string $target Target Contact Identity
     * @return $this Fluent Builder
     */
    public function setTarget($target) {
        $this->options['target'] = $target;
        return $this;
    }

    /**
     * Chat channel unique name
     *
     * @param string $chatUniqueName Chat channel unique name
     * @return $this Fluent Builder
     */
    public function setChatUniqueName($chatUniqueName) {
        $this->options['chatUniqueName'] = $chatUniqueName;
        return $this;
    }

    /**
     * Pre-engagement data
     *
     * @param string $preEngagementData Pre-engagement data
     * @return $this Fluent Builder
     */
    public function setPreEngagementData($preEngagementData) {
        $this->options['preEngagementData'] = $preEngagementData;
        return $this;
    }

    /**
     * The unique SID identifier of the Taskrouter task
     *
     * @param string $taskSid TaskRouter Task Sid.
     * @return $this Fluent Builder
     */
    public function setTaskSid($taskSid) {
        $this->options['taskSid'] = $taskSid;
        return $this;
    }

    /**
     * Task attributes to be added for the TaskRouter Task
     *
     * @param string $taskAttributes Task attributes to be added for the TaskRouter
     *                               Task
     * @return $this Fluent Builder
     */
    public function setTaskAttributes($taskAttributes) {
        $this->options['taskAttributes'] = $taskAttributes;
        return $this;
    }

    /**
     * Boolean flag determining whether channel is created as long lived or not
     *
     * @param bool $longLived Long Lived flag
     * @return $this Fluent Builder
     */
    public function setLongLived($longLived) {
        $this->options['longLived'] = $longLived;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.FlexApi.V1.CreateChannelOptions ' . implode(' ', $options) . ']';
    }
}