
<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                <?php echo lang('doctors_commission'); ?>      
                    <span style="color:red">(<?php
                        if (!empty($from) && !empty($to)) {
                            echo '<strong>From '. date("d-M-Y", strtotime($from)). ' To '.date("d-M-Y", strtotime($to)).'</strong>';
                        }
                        ?>) 
                    </span>
            </header>

            <div class="col-md-12">
                <div class="panel-body col-md-9">
                    <section>
                        <form role="form" action="finance/doctorsCommission" method="post" >
                            <div class="form-group">
                                <div class="col-md-6">
                                    <div class="input-group input-large" data-date="13/07/2013" data-date-format="mm/dd/yyyy">
                                        <input type="text" class="form-control dpd1" name="date_from" value="<?php
                                        if (!empty($from)) {
                                            echo $from;
                                        }
                                        ?>" placeholder="<?php echo lang('date_from'); ?>"readonly="">
                                        <span class="input-group-addon">To</span>
                                        <input type="text" class="form-control dpd2" name="date_to" value="<?php
                                        if (!empty($to)) {
                                            echo $to;
                                        }
                                        ?>" placeholder="<?php echo lang('date_to'); ?>"readonly="">
                                    </div>
                                    <div class="row"></div>
                                    <span class="help-block"></span> 
                                </div>
                                <div class="col-md-6">
                                    <button type="submit" name="submit" class="btn btn-info"><?php echo lang('submit'); ?></button>
                                </div>
                            </div>
                        </form>
                    </section>
                </div>
            </div>



            <div class="panel-body">
                <div class="adv-table editable-table ">
                <div class="space15"></div>
                     <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th><?php echo lang('doctor_id'); ?></th>
                                <th><?php echo lang('doctor'); ?></th>
                                <th><?php echo lang('total'); ?> <?php echo lang('commission'); ?> (<?php echo $settings->currency; ?>)</th>
                                <th><?php echo lang('total'); ?> <?php echo lang('grand'); ?> <?php echo lang('amount'); ?> (<?php echo $settings->currency; ?>)</th>
                                <th><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($doctors as $doctor) { ?>

                            <tr class="">
                                <td><?php echo $doctor->id; ?></td>
                                <td><?php echo $doctor->name; ?>, (<?php echo $doctor->profile; ?>)</td>
                                <td>
                                    <?php
                                    foreach ($payments as $payment) {
                                        if ($payment->doctor == $doctor->id) {    
                                                $gross_amount[] = $payment->gross_total;
                                                $doctor_amount[] = $payment->doctor_amount;            
                                        }
                                    }
                                    if (!empty($doctor_amount)) {
                                        $doctor_total = array_sum($doctor_amount);
                                        $gross_total = array_sum($gross_amount);
                                        echo $doctor_total;
                                    } else {
                                        $doctor_total = 0;
                                        echo $doctor_total;
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php                             
                                    if (!empty($gross_total)) {
                                        echo $gross_total;
                                    } else {
                                        echo'0';
                                    }
                                    ?>
                                </td>
                                <td> <a class="btn btn-info btn-xs invoicebutton" href="finance/docComDetails?id=<?php echo $doctor->id.'&date_from='.$from.'&date_to='.$to; ?>" target="_blank"><i class="fa fa-clone" > <?php echo lang('details'); ?></i></a></td>
                          </tr>
                            <?php $doctor_amount = NULL; ?>
                            <?php $doctor_gross = NULL; ?>
                            <?php $gross_amount = NULL; ?>
                            <?php $gross_total = NULL; ?>
                        <?php } ?>



                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,

            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [0, 1, 2, 3],
                    }
                },
            ],

            aLengthMenu: [
                [10, 20, 30, 50, 100, -1],
                [10, 20, 30, 50, 100, "All"]
            ],
            iDisplayLength: 50,
            "order": [[2, "desc"]],
            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                searchPlaceholder: "Search...",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json"
            }
        });
        table.buttons().container().appendTo('.custom_buttons');
    });
</script>